from OpenGL.GL import *
from pygame.locals import *
from math import *
import array
import pygame
import time
import sys
from random import random

X = 1024
Y = 1024

parameters = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0]

def init():    
    global texID

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    glDisable(GL_DEPTH_TEST)
    texID = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

def jitter(): return (random()*2 - 1) * 0.01

theta = 0

def intersect_circles(c1, c2, r1, r2):
    dx = c2[0] - c1[0]
    dy = c2[1] - c1[1]
    d = sqrt(dx*dx + dy*dy)

    a = ((r1*r1) - (r2*r2) + (d*d)) / (2.0 * d)

    c3 = (c1[0] + (dx * a/d), c1[1] + (dy * a/d))

    h = sqrt((r1*r1) - (a*a))

    r = (-dy * (h/d), dx * (h/d))

    return ((c3[0] + r[0], c3[1] + r[1]), (c3[0] - r[0], c3[1] - r[1]))

def draw():
    global theta
    theta -= 0.1

    # draw the texture
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)
    glColor(0.99, 0.99, 0.98)
    #glScale(1.03, 1.03, 1.03)
    glBegin(GL_QUADS)
    glVertex3f(-1.0, -1.0, 0); glTexCoord2i(1, 0)
    glVertex3f(1.0, -1.0, 0);  glTexCoord2i(1, 1)
    glVertex3f(1.0, 1.0, 0);   glTexCoord2i(0, 1)
    glVertex3f(-1.0, 1.0, 0);  glTexCoord2i(0, 0)
    glEnd()

    glTranslate(-0.6, 0.6, 0)
    glScale(0.5, 0.5, 0.5)

    try:
        # set c
        c = (1.0 + cos(theta)/5, -1.0 + sin(theta)/5)
        # solve for a
        a = intersect_circles((0, 0), c, parameters[0], parameters[1])[0]
        # solve for b
        r = (parameters[0] + parameters[2])/parameters[0]
        b = (r*a[0], r*a[1])
        # solve for d
        d = intersect_circles(c, b, parameters[4], parameters[3])[1]
        # solve for e
        r = (parameters[3] + parameters[5])/parameters[3]
        e = (r*(d[0] - b[0]) + b[0], r*(d[1] - b[1]) + b[1])
    
        glPointSize(3)
        glDisable(GL_TEXTURE_2D)
        glBegin(GL_POINTS)
        glColor3f(0.5, 0.5, 1.0)
        glVertex2f(0, 0)
        glVertex2f(a[0], a[1])
        glVertex2f(b[0], b[1])
        glVertex2f(c[0], c[1])
        glVertex2f(d[0], d[1])
        glVertex2f(e[0], e[1])
        glEnd()

    except: pass

    # copy it into a texture
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)
    glDisable(GL_TEXTURE_2D)

    try: 
        glBegin(GL_LINES)
        glColor3f(0.5, 0.5, 0.5)
        
        glVertex2f(0, 0)
        glVertex2f(b[0], b[1])
        
        glVertex2f(b[0], b[1])
        glVertex2f(e[0], e[1])
        
        glVertex2f(c[0], c[1])
        glVertex2f(d[0], d[1])
        
        glVertex2f(c[0], c[1])
        glVertex2f(a[0], a[1])
        glEnd()
    except:
        glEnd()

def mainloop():
    glClearColor(0, 0, 0, 0)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        elif ev.type == KEYDOWN:
            k = chr(ev.key)
            if k == 'q':
                parameters[0] *= 1.1
            elif k == 'a':
                parameters[0] *= 1.0/1.1
            elif k == 'w':
                parameters[1] *= 1.1
            elif k == 's':
                parameters[1] *= 1.0/1.1
            elif k == 'e':
                parameters[2] *= 1.1
            elif k == 'd':
                parameters[2] *= 1.0/1.1
            elif k == 'r':
                parameters[3] *= 1.1
            elif k == 'f':
                parameters[3] *= 1.0/1.1                                
            elif k == 't':
                parameters[4] *= 1.1
            elif k == 'g':
                parameters[4] *= 1.0/1.1
            elif k == 'y':
                parameters[5] *= 1.1
            elif k == 'h':
                parameters[5] *= 1.0/1.1                                                
            
        
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.001)
